/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0015\u001a\u00020\u0003\u0012\u0006\u0010I\u001a\u00020H\u0012\u0006\u0010N\u001a\u00020M\u00a2\u0006\u0004\bZ\u0010[J\u0015\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005JY\u0010\u000f\u001a8\u0012(\u0012&\u0012\u0004\u0012\u00020\u0007\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f`\r0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00020\t2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ5\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00020\t2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0010J\u001d\u0010!\u001a\u00020 2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002H\u0014\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0004\b#\u0010\u0005J!\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\tH\u0002\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b&\u0010'J)\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020 H\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020 H\u0016\u00a2\u0006\u0004\b/\u0010.J\u0017\u00103\u001a\u0002022\u0006\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\b3\u00104J\u000f\u00105\u001a\u000202H\u0016\u00a2\u0006\u0004\b5\u00106J5\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u00020\t2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0016\u00a2\u0006\u0004\b8\u0010\u0010J\u0017\u00109\u001a\u0002022\u0006\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b9\u0010:J\u001b\u0010=\u001a\u00020\u0003*\u00020\u00032\u0006\u0010<\u001a\u00020;H\u0004\u00a2\u0006\u0004\b=\u0010>R\u001e\u0010?\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010@R*\u0010A\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0005R,\u0010F\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0E0D8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\bF\u0010B\u001a\u0004\bG\u0010%R\u001a\u0010I\u001a\u00020H8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bI\u0010J\u001a\u0004\bK\u0010LR\u001a\u0010N\u001a\u00020M8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bN\u0010O\u001a\u0004\bP\u0010QR\u001a\u0010\u0015\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010R\u001a\u0004\bS\u0010'R\u001a\u0010T\u001a\u0002028\u0016X\u0096D\u00a2\u0006\f\n\u0004\bT\u0010U\u001a\u0004\bV\u00106R\u001b\u00105\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bW\u0010X\u001a\u0004\bY\u00106\u00a8\u0006\\"}, d2={"Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "", "", "allTablesNames", "()Ljava/util/List;", "", "Lorg/jetbrains/exposed/sql/Table;", "tables", "", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/Column;", "Lkotlin/collections/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "columnConstraints", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "Lorg/jetbrains/exposed/sql/Index;", "index", "createIndex", "(Lorg/jetbrains/exposed/sql/Index;)Ljava/lang/String;", "name", "table", "columns", "type", "createIndexWithType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "tableName", "indexName", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "existingIndices", "", "fillConstraintCacheForTables", "(Ljava/util/List;)V", "getAllSchemaNamesCache", "getAllTableNamesCache", "()Ljava/util/Map;", "getDatabase", "()Ljava/lang/String;", "column", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "modifyColumn", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "resetCaches", "()V", "resetSchemaCaches", "Lorg/jetbrains/exposed/sql/Schema;", "schema", "", "schemaExists", "(Lorg/jetbrains/exposed/sql/Schema;)Z", "supportsSelectForUpdate", "()Z", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tableColumns", "tableExists", "(Lorg/jetbrains/exposed/sql/Table;)Z", "Lorg/jetbrains/exposed/sql/Transaction;", "tr", "quoteIdentifierWhenWrongCaseOrNecessary", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "_allSchemaNames", "Ljava/util/List;", "_allTableNames", "Ljava/util/Map;", "getAllTablesNames", "", "", "columnConstraintsCache", "getColumnConstraintsCache", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "functionProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "Ljava/lang/String;", "getName", "supportsMultipleGeneratedKeys", "Z", "getSupportsMultipleGeneratedKeys", "supportsSelectForUpdate$delegate", "Lkotlin/Lazy;", "getSupportsSelectForUpdate", "<init>", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;)V", "exposed-core"})
public abstract class VendorDialect
implements DatabaseDialect {
    @NotNull
    private final String name;
    @NotNull
    private final DataTypeProvider dataTypeProvider;
    @NotNull
    private final FunctionProvider functionProvider;
    @Nullable
    private Map<String, ? extends List<String>> _allTableNames;
    @Nullable
    private List<String> _allSchemaNames;
    private final boolean supportsMultipleGeneratedKeys;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Map<String, Collection<ForeignKeyConstraint>> columnConstraintsCache;

    public VendorDialect(@NotNull String name, @NotNull DataTypeProvider dataTypeProvider, @NotNull FunctionProvider functionProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dataTypeProvider, (String)"dataTypeProvider");
        Intrinsics.checkNotNullParameter((Object)functionProvider, (String)"functionProvider");
        this.name = name;
        this.dataTypeProvider = dataTypeProvider;
        this.functionProvider = functionProvider;
        this.supportsMultipleGeneratedKeys = true;
        this.supportsSelectForUpdate$delegate = LazyKt.lazy((Function0)supportsSelectForUpdate.2.INSTANCE);
        this.columnConstraintsCache = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DataTypeProvider getDataTypeProvider() {
        return this.dataTypeProvider;
    }

    @Override
    @NotNull
    public FunctionProvider getFunctionProvider() {
        return this.functionProvider;
    }

    @NotNull
    public final List<String> getAllTablesNames() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        return (List)MapsKt.getValue(this.getAllTableNamesCache(), connection.metadata(allTablesNames.1.INSTANCE));
    }

    private final Map<String, List<String>> getAllTableNamesCache() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        if (this._allTableNames == null) {
            this._allTableNames = (Map)connection.metadata(getAllTableNamesCache.1.INSTANCE);
        }
        Map<String, List<String>> map2 = this._allTableNames;
        Intrinsics.checkNotNull(map2);
        return map2;
    }

    private final List<String> getAllSchemaNamesCache() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        if (this._allSchemaNames == null) {
            this._allSchemaNames = (List)connection.metadata(getAllSchemaNamesCache.1.INSTANCE);
        }
        List<String> list2 = this._allSchemaNames;
        Intrinsics.checkNotNull(list2);
        return list2;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    @NotNull
    public String getDatabase() {
        return this.catalog(TransactionManager.Companion.current());
    }

    @Override
    @NotNull
    public List<String> allTablesNames() {
        return (List)TransactionManager.Companion.current().getConnection().metadata(allTablesNames.2.INSTANCE);
    }

    @Override
    public boolean tableExists(@NotNull Table table) {
        boolean bl;
        block4: {
            String tableScheme;
            String string;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            String it = string = StringsKt.substringBefore((String)table.getTableName(), (char)'.', (String)"");
            boolean bl2 = false;
            String string2 = tableScheme = ((CharSequence)it).length() > 0 ? string : null;
            String string3 = string2 == null ? null : DefaultKt.inProperCase(string2);
            if (string3 == null) {
                string3 = (String)TransactionManager.Companion.current().getConnection().metadata(tableExists.scheme.1.INSTANCE);
            }
            String scheme2 = string3;
            List allTables = (List)MapsKt.getValue(this.getAllTableNamesCache(), (Object)scheme2);
            Iterable $this$any$iv = allTables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it2 = (String)element$iv;
                    boolean bl3 = false;
                    boolean bl4 = tableScheme != null ? Intrinsics.areEqual((Object)it2, (Object)table.nameInDatabaseCase()) : (((CharSequence)scheme2).length() == 0 ? Intrinsics.areEqual((Object)it2, (Object)table.nameInDatabaseCase()) : Intrinsics.areEqual((Object)it2, (Object)DefaultKt.inProperCase(scheme2 + '.' + table.getTableNameWithoutScheme$exposed_core())));
                    if (!bl4) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean schemaExists(@NotNull Schema schema) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            List<String> allSchemas = this.getAllSchemaNamesCache();
            Iterable $this$any$iv = allSchemas;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)DefaultKt.inProperCase(schema.getIdentifier()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Map<Table, List<ColumnMetadata>> tableColumns(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getConnection().metadata((Function1)new Function1<ExposedDatabaseMetadata, Map<Table, ? extends List<? extends ColumnMetadata>>>(tables){
            final /* synthetic */ Table[] $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<Table, List<ColumnMetadata>> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
                return $this$metadata.columns(Arrays.copyOf(this.$tables, this.$tables.length));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(Table ... tables) {
        Iterable it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        HashMap constraints = new HashMap();
        Table[] $this$filter$iv = tables;
        boolean $i$f$filter = false;
        Table[] tableArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            boolean bl = false;
            if (!(!this.getColumnConstraintsCache().containsKey(((Table)((Object)it)).nameInDatabaseCase()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesToLoad = (List)destination$iv$iv;
        this.fillConstraintCacheForTables(tablesToLoad);
        Table[] $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        tableArray = $this$forEach$iv;
        int n = 0;
        int n2 = tableArray.length;
        while (n < n2) {
            void $this$forEach$iv2;
            Table element$iv = tableArray[n];
            ++n;
            Table table = element$iv;
            boolean bl = false;
            Collection collection = this.getColumnConstraintsCache().get(table.nameInDatabaseCase());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            it = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                void $this$getOrPut$iv;
                ForeignKeyConstraint it2 = (ForeignKeyConstraint)element$iv2;
                boolean bl2 = false;
                Map map2 = constraints;
                Pair key$iv = TuplesKt.to((Object)table, it2.getFrom());
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(it2);
            }
        }
        return constraints;
    }

    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_core((Function1)new Function1<ExposedDatabaseMetadata, Map<Table, ? extends List<? extends Index>>>(tables){
            final /* synthetic */ Table[] $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<Table, List<Index>> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
                return $this$metadata.existingIndices(Arrays.copyOf(this.$tables, this.$tables.length));
            }
        });
    }

    private final boolean getSupportsSelectForUpdate() {
        Lazy lazy2 = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return this.getSupportsSelectForUpdate();
    }

    @NotNull
    protected final String quoteIdentifierWhenWrongCaseOrNecessary(@NotNull String $this$quoteIdentifierWhenWrongCaseOrNecessary, @NotNull Transaction tr) {
        Intrinsics.checkNotNullParameter((Object)$this$quoteIdentifierWhenWrongCaseOrNecessary, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        return tr.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary($this$quoteIdentifierWhenWrongCaseOrNecessary);
    }

    @NotNull
    protected final Map<String, Collection<ForeignKeyConstraint>> getColumnConstraintsCache() {
        return this.columnConstraintsCache;
    }

    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        this.columnConstraintsCache.putAll((Map)TransactionManager.Companion.current().getDb().metadata$exposed_core((Function1)new Function1<ExposedDatabaseMetadata, Map<String, ? extends List<? extends ForeignKeyConstraint>>>(tables){
            final /* synthetic */ List<Table> $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<String, List<ForeignKeyConstraint>> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
                return $this$metadata.tableConstraints(this.$tables);
            }
        }));
    }

    @Override
    public void resetCaches() {
        this._allTableNames = null;
        this.columnConstraintsCache.clear();
        TransactionManager.Companion.current().getDb().metadata$exposed_core(resetCaches.1.INSTANCE);
    }

    @Override
    public void resetSchemaCaches() {
        this._allSchemaNames = null;
        this.resetCaches();
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Transaction t = TransactionManager.Companion.current();
        String quotedTableName = t.identity(index.getTable());
        String quotedIndexName = t.getDb().getIdentifierManager().cutIfNecessaryAndQuote(index.getIndexName());
        String columnsList2 = CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(t){
            final /* synthetic */ Transaction $t;
            {
                this.$t = $t;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Column<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$t.identity(it);
            }
        }, (int)25, null);
        return index.getUnique() ? "ALTER TABLE " + quotedTableName + " ADD CONSTRAINT " + quotedIndexName + " UNIQUE " + columnsList2 : (index.getIndexType() != null ? this.createIndexWithType(quotedIndexName, quotedTableName, columnsList2, index.getIndexType()) : "CREATE INDEX " + quotedIndexName + " ON " + quotedTableName + ' ' + columnsList2);
    }

    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns2, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return "CREATE INDEX " + name + " ON " + table + ' ' + columns2 + " USING " + type;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName2, (String)"indexName");
        IdentifierManagerApi identifierManager2 = TransactionManager.Companion.current().getDb().getIdentifierManager();
        return "ALTER TABLE " + identifierManager2.quoteIfNecessary(tableName) + " DROP CONSTRAINT " + identifierManager2.quoteIfNecessary(indexName2);
    }

    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        return CollectionsKt.listOf((Object)("ALTER TABLE " + TransactionManager.Companion.current().identity(column.getTable()) + " MODIFY COLUMN " + column.descriptionDdl(true)));
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return DatabaseDialect.DefaultImpls.getSupportsIfNotExists(this);
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSequence(this);
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return DatabaseDialect.DefaultImpls.getNeedsSequenceToAutoInc(this);
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return DatabaseDialect.DefaultImpls.getDefaultReferenceOption(this);
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return DatabaseDialect.DefaultImpls.getNeedsQuotesWhenSymbolsInNames(this);
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsSequenceAsGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsOnlyIdentifiersInGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSchema(this);
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return DatabaseDialect.DefaultImpls.getSupportsSubqueryUnions(this);
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return DatabaseDialect.DefaultImpls.getSupportsDualTableConcept(this);
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return DatabaseDialect.DefaultImpls.getSupportsOrderByNullsFirstLast(this);
    }

    @Override
    public boolean checkTableMapping(@NotNull Table table) {
        return DatabaseDialect.DefaultImpls.checkTableMapping(this, table);
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        return DatabaseDialect.DefaultImpls.isAllowedAsColumnDefault(this, e);
    }

    @Override
    @NotNull
    public String catalog(@NotNull Transaction transaction2) {
        return DatabaseDialect.DefaultImpls.catalog(this, transaction2);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        return DatabaseDialect.DefaultImpls.createDatabase(this, name);
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        return DatabaseDialect.DefaultImpls.dropDatabase(this, name);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.setSchema(this, schema);
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.createSchema(this, schema);
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        return DatabaseDialect.DefaultImpls.dropSchema(this, schema, cascade);
    }
}

